<?php

/**
 * iBid4Storage API PHP class
 *
 * Copyright 2015, iBid4Storage.com
 * Licensed under the MIT License.
 * Redistributions of files must retain the above copyright notice.
 *
 * @author iBid4Storage.com
 * @copyright Copyright 2015, iBid4Storage.com
 * @version 0.5.1
 * @license http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class ApiIbid4Storage
{
	
	protected $apiUrl;
	protected $timeout = 60;//i change it from 30 to 60
	
	protected $errorMessage;
	protected $errorCode;
	
	protected $userName;
	protected $apiKey;
	protected $local;
	
	protected $token;
	protected $endDate;
	
	protected $authentication;
	
	/**
	 * Wrapper contructor : initialize the API url and retrieve a session token
	 *
	 * @param string $url
	 * @param string $userName
	 * @param string $apiKey
	 * @param string $local
	 * @return string
	 */
	public function __construct($url, $userName, $apiKey, $local) {
		$this->apiUrl = $url;
		$this->token = false;
		$this->errorMessage = null;
		$this->errorCode = null;
		
		$this->userName 	= $userName;
		$this->apiKey 		= $apiKey;
		$this->local 		= $local;
	
		$this->authentication = $this->getSessionToken();
	}
	
	/**
	 * Get a session token
	 * @return array
	 */
	private function getSessionToken() {
		$params = array();
		$params['userName'] = $this->userName;
		$params['apiKey'] 	= $this->apiKey;
		$params['local'] 	= $this->local;
		
		$params['class']  = 'Session';
		$params['method'] = 'getToken';
		$authentication = json_decode($this->callServer($params));
		
		if(isset($authentication->token) && isset($authentication->endDate)){
			$this->token = $authentication->token;
			$this->endDate = $authentication->endDate;
			return $authentication;
		}
		
		if(!empty($authentication->error_id) && !empty($authentication->error_msg)){
			$this->errorMessage = $authentication->error_msg;
			$this->errorCode	= $authentication->error_id;
		}
		
		return null;
	}
	
	/**
	 * Method used to communicate with API
	 *
	 * @param string $params
	 * @return array
	 */
	private function callServer($params) {
		
		$ch = null;
		
		$fields_string = '';
		$fields_string = http_build_query($params);
		$defaults = array(
				CURLOPT_POST => 1,
				CURLOPT_HEADER => 0,
				CURLOPT_URL => $this->apiUrl,
				CURLOPT_FRESH_CONNECT => 1,
				CURLOPT_RETURNTRANSFER => 1,
				CURLOPT_FORBID_REUSE => 1,
				CURLOPT_TIMEOUT => 300,
				CURLOPT_POSTFIELDS => $fields_string,
				CURLOPT_HTTPHEADER => array( 'Content-Type: application/x-www-form-urlencoded' )
		);
		
		$ch = curl_init();
		curl_setopt_array($ch, ($defaults));
		$result = false;
		$result = curl_exec($ch);
		
		curl_close($ch);
		
		if (!$result) {
			$this->errorMessage = "No response from API server";
			$this->errorCode = "-106";
			mail('thinkdev@thinkbound.com', 'iBid4Storage - cURL ERROR', trigger_error(curl_error($ch)));
		}
		
		return $result;
	}
	
	/**
	 * Get all active units
	 * 
	 * @param string $type (enum 'all', 'new', 'updated')
	 * @param int $limit (optional, no limit if empty)
	 * @return multitype:|boolean
	 */
	public function fetchAllUnits($startDate,$endDate,$locationId=0){
		
		$sessionRenewed = true;
		
		$currentDate = date_format(new \DateTime(),'Y-m-d H:i:s');
       
		if ($currentDate > $this->endDate) {
			$sessionRenewed = $this->getSessionToken();
		}
		
		if($sessionRenewed) {
			$params = array();
			$params['token'] 		= $this->token;
			$params['class'] 		= 'Units';
			$params['method'] 		= 'fetchAllUnits';
			$params['fetchType'] 	= 'all';
			$params['limit'] 		= '1000';
			$params['locationId'] 	= $locationId;
			$params['startDate'] 	= $startDate;
			$params['endDate'] 	= $endDate;

			return $this->callServer($params);
		}
		return false;
	}
	
	/**
	 * Get all active and closing soon units
	 * @param int $limit
	 */
	public function fetchActiveAndClosingSoonUnits($locationId=0,$limit = 1000){
		
		$sessionRenewed = true;

		$currentDate = date_format(new \DateTime(),'Y-m-d H:i:s');
		
		if ($currentDate > $this->endDate) {
			$sessionRenewed = $this->getSessionToken();
		}
		
		if($sessionRenewed) {
			$params = array();
			$params['token'] 	= $this->token;
			$params['class'] 	= 'Units';
			$params['method'] 	= 'fetchActiveAndClosingSoonUnits';
			$params['limit'] 	= $limit;
			$params['locationId'] 	= $locationId;

			return $this->callServer($params);
		}
		return false;
	}

	/**
	 * Get all location UniqueIDs
	 * @param int $limit
	 */
	public function fetchAllLocationsInfo(){
		
		$sessionRenewed = true;

		$currentDate = date_format(new \DateTime(),'Y-m-d H:i:s');
		
		if ($currentDate > $this->endDate) {
			$sessionRenewed = $this->getSessionToken();
		}
		
		if($sessionRenewed) {
			$params = array();
			$params['token'] 	= $this->token;
			$params['class'] 	= 'Units';
			$params['method'] 	= 'getLocationUniqueIDs';

			return $this->callServer($params);
		}
		return false;
	}
	
	
}